/*
 * Decompiled with CFR 0.152.
 */
package club.someoneice.jellyfishingdelight.block;

import club.someoneice.jellyfishingdelight.core.TileList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GrillTile
extends BlockEntity {
    public final ItemStackHandler container = new ItemStackHandler(6);
    private int[] cookingTimes = new int[6];
    private int[] cookingTimesTotal = new int[6];
    private final ItemStack[] output = new ItemStack[6];

    public GrillTile(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)TileList.GRILL.get(), pPos, pBlockState);
    }

    protected void m_183515_(@NotNull CompoundTag nbt) {
        nbt.m_128365_("container", (Tag)this.container.serializeNBT());
        nbt.m_128385_("cookingTime", this.cookingTimes);
        nbt.m_128385_("cookingTimesTotal", this.cookingTimesTotal);
        super.m_183515_(nbt);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.container.deserializeNBT(nbt.m_128469_("container"));
        this.cookingTimes = nbt.m_128465_("cookingTime");
        this.cookingTimesTotal = nbt.m_128465_("cookingTimesTotal");
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.m_183515_(nbt);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
        return super.getCapability(cap);
    }

    public static void cookingTick(Level pLevel, BlockPos pPos, BlockState pBlockState, GrillTile tile) {
        IntArrayList list = new IntArrayList();
        if (tile.shouldPop()) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            if (tile.container.getStackInSlot(i).m_41619_()) continue;
            list.add(i);
        }
        boolean flag = pLevel.m_6425_(pPos.m_7494_()).m_205070_(FluidTags.f_13131_);
        list.intStream().sorted().filter(it -> !tile.container.getStackInSlot(it).m_41619_()).forEach(it -> {
            CampfireCookingRecipe recipe = GrillTile.getRecipe(pLevel, tile.container.getStackInSlot(it));
            assert (recipe != null);
            tile.cookingTimesTotal[it] = Mth.m_14107_((double)((double)recipe.m_43753_() * (flag ? 0.7 : 1.0)));
            tile.output[it] = recipe.m_8043_(pLevel.m_9598_()).m_41777_();
            int n = it;
            tile.cookingTimes[n] = tile.cookingTimes[n] + 1;
            if (tile.cookingTimes[n] >= tile.cookingTimesTotal[it]) {
                tile.cookingTimes[it] = 0;
                tile.cookingTimesTotal[it] = 0;
                tile.container.setStackInSlot(it, ItemStack.f_41583_);
                tile.send();
                if (tile.output[it] == null || tile.output[it].m_41619_()) {
                    tile.output[it] = null;
                    return;
                }
                pLevel.m_7967_((Entity)new ItemEntity(pLevel, (double)tile.m_58899_().m_123341_() + 0.5, (double)(tile.m_58899_().m_123342_() + 1), (double)tile.m_58899_().m_123343_() + 0.5, tile.output[it].m_41777_()));
                tile.output[it] = null;
            }
        });
    }

    private boolean shouldPop() {
        if (!this.m_58898_()) {
            return true;
        }
        assert (this.f_58857_ != null);
        if (this.f_58857_.f_46443_) {
            return true;
        }
        if (!this.f_58857_.m_8055_(this.m_58899_().m_7494_()).m_60795_()) {
            return !this.f_58857_.m_6425_(this.m_58899_().m_7494_()).m_205070_(FluidTags.f_13131_);
        }
        return false;
    }

    public static boolean canPut(Level world, ItemStack item) {
        return Objects.nonNull(GrillTile.getRecipe(world, item));
    }

    public boolean putItem(ItemStack item) {
        for (int i = 0; i < this.container.getSlots(); ++i) {
            ItemStack it = this.container.getStackInSlot(i);
            if (!it.m_41619_()) continue;
            this.container.setStackInSlot(i, item.m_255036_(1));
            item.m_41774_(1);
            this.send();
            return true;
        }
        return false;
    }

    private void send() {
        if (!this.m_58898_()) {
            return;
        }
        assert (this.f_58857_ != null);
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        ((ServerLevel)this.f_58857_).m_6907_().forEach(it -> it.f_8906_.m_9829_(this.m_58483_()));
    }

    @Nullable
    private static CampfireCookingRecipe getRecipe(Level world, ItemStack item) {
        Optional recipe = world.m_7465_().m_44015_(RecipeType.f_44111_, (Container)new SimpleContainer(new ItemStack[]{item}), world);
        return recipe.orElse(null);
    }
}

